; IDL Version 7.0, Mac OS X (darwin i386 m32)
; Journal File for baptiste@macbookbc.obspm.fr
; Working directory: /Users/baptiste/Projets/CDPP/Archivage/Cassini:RPWS/QTN/CDF
; Date: Thu Jun 12 12:04:25 2014
;
; RUN @compile_IDLmakecdf
;
; NB: compile_IDLmakecdf.pro script is part of the CDF CDAWlib distribution 
; available here: http://spdf.gsfc.nasa.gov/CDAWlib.html

; DECLARING VERSIONS
sft_version = '11'
cdf_version = '08'
sav_version = '03'

; DECLARING PATHS
cdf_datapath = 'data/cdf/V'+sft_version+'/'
sav_datapath = 'data/sav/V'+sav_version+'/'
master_cdf = cdf_datapath+'master/co_rpws_hfr_qtn_000000000000_000000000000_v'+cdf_version+'.cdf'
skelet_cdf = cdf_datapath+'master/co_rpws_hfr_qtn_000000000000_000000000000_v'+cdf_version+'.skt'

; CLEANING AND REBUILDING MASTER CDF
spawn,'rm -f '+master_cdf
spawn,'skeletoncdf -cdf '+master_cdf+' '+skelet_cdf

; OPENING 2 FILES FOR HOUSEKEEPING OUTPUT
openw,lun1,cdf_datapath+'misc/interval_listing.txt',/get_lun
printf,lun1,"    REV NDATA  TIME START        TIME STOP            "
printf,lun1,"    --- -----  ----------------  ----------------     "
printf,lun1,"                                                      "

openw,lun2,cdf_datapath+'misc/cdf_pds_check.txt',/get_lun

; BUILDING LIST OF DATA FILES
files = file_search(sav_datapath+"neTecore_rev*.sav")
nfiles = n_elements(files)
message,/info,'Found '+strtrim(string(nfiles),2)+' input files.'

; =============================================================================
; LOOPING ON DATA FILES
; =============================================================================

for j=0l,N_ELEMENTS(files)-1 do begin

restore,files[j],/verb

ndata = n_elements(T_AJ_NSWEEP_V2_ORBIT)
time_epoch = dblarr(ndata)
time_jd = dblarr(ndata)
time_iso = strarr(ndata)
for i=0l,ndata-1 do begin
  YY = long(T_AJ_NSWEEP_V2_ORBIT[i])/1000l
  DD = long(T_AJ_NSWEEP_V2_ORBIT[i] mod 1000l)
  MS = round((T_AJ_NSWEEP_V2_ORBIT[i] mod 1)*86400d3)
  cdf_epoch,epoch_tmp,YY,0,DD,0,0,0,MS,/compute 
  time_epoch[i] = epoch_tmp
  time_iso[i] = cdf_encode_epoch(epoch_tmp,epoch=3)
endfor


TIME_JD = dblarr(ndata)-1e+31
ww = where(finite(TEMPSJD_NSWEEP_V2_ORBIT),cnt)
if (cnt ne 0) then TIME_JD[ww] = TEMPSJD_NSWEEP_V2_ORBIT[ww]

NE_CORE_FINAL = fltarr(ndata)-1e+31
ww = where(finite(NE_CORE_CC_CLEANED_ORBIT),cnt)
if (cnt ne 0) then ne_core_final[ww] = NE_CORE_CC_CLEANED_ORBIT[ww]

DNE_CORE_FINAL = fltarr(ndata)-1e+31
ww = where(finite(DELTA_NE_CORE_CC_CLEANED_ORBIT),cnt)
if cnt ne 0 then DNE_CORE_FINAL[ww] = DELTA_NE_CORE_CC_CLEANED_ORBIT[ww]

TE_CORE_FINAL = fltarr(ndata)-1e+31
ww = where(finite(TE_CORE_EV_CLEANED_ORBIT) and TE_CORE_EV_CLEANED_ORBIT gt 0.1,cnt)
if cnt ne 0 then TE_CORE_FINAL[ww] = TE_CORE_EV_CLEANED_ORBIT[ww]

DTE_CORE_FINAL = fltarr(ndata)-1e+31
ww = where(finite(DELTA_TE_CORE_EV_CLEANED_ORBIT),cnt)
if cnt ne 0 then DTE_CORE_FINAL[ww] = DELTA_TE_CORE_EV_CLEANED_ORBIT[ww]

QF_TE_CORE_FINAL = fltarr(ndata)-1e+31
ww = where(finite(QUALITY_FLAG_TE_ORBIT),cnt)
if cnt ne 0 then QF_TE_CORE_FINAL[ww] = QUALITY_FLAG_TE_ORBIT[ww]

R_EPHEM_FINAL = fltarr(ndata)-1e+31
ww = where(finite(R_EPHEM_NSWEEP_ORBIT),cnt)
if cnt ne 0 then R_EPHEM_FINAL[ww] = R_EPHEM_NSWEEP_ORBIT[ww]

LAT_EPHEM_FINAL = fltarr(ndata)-1e+31
ww = where(finite(LAT_EPHEM_NSWEEP_ORBIT),cnt)
if cnt ne 0 then LAT_EPHEM_FINAL[ww] = LAT_EPHEM_NSWEEP_ORBIT[ww]

LT_EPHEM_FINAL = fltarr(ndata)-1e+31
ww = where(finite(LT_EPHEM_NSWEEP_ORBIT),cnt)
if cnt ne 0 then LT_EPHEM_FINAL[ww] = LT_EPHEM_NSWEEP_ORBIT[ww]

LSHELL_EPHEM_FINAL = fltarr(ndata)-1e+31
ww = where(finite(LSHELL_EPHEM_NSWEEP_ORBIT),cnt)
if cnt ne 0 then LSHELL_EPHEM_FINAL[ww] = LSHELL_EPHEM_NSWEEP_ORBIT[ww]

;BMAG_FINAL = fltarr(ndata)-1e+31
;ww = where(finite(BMAG_TAJ_NSWEEP_CONCAT),cnt)
;if cnt ne 0 then BMAG_FINAL[ww] = BMAG_TAJ_NSWEEP_CONCAT[ww]

ww = where(finite(NE_CORE_CC_CLEANED_ORBIT) or finite(TE_CORE_EV_CLEANED_ORBIT),cnt)

cdf_data = {epoch:dblarr(cnt),jd_time:dblarr(cnt),scet:strarr(cnt), $
            ne_core:fltarr(cnt),te_core:fltarr(cnt),$
			d_ne_core:fltarr(cnt),d_te_core:fltarr(cnt),qf_te_core:fltarr(cnt),$
			r_dist:fltarr(cnt),latitude:fltarr(cnt),$
			local_time:fltarr(cnt),l_shell:fltarr(cnt)};,b_mag:fltarr(ndata)}
			
cdf_data.epoch=time_epoch[ww]
cdf_data.jd_time=time_jd[ww]
cdf_data.scet=time_iso[ww]
cdf_data.ne_core=NE_CORE_FINAL[ww]
cdf_data.te_core=TE_CORE_FINAL[ww]
cdf_data.d_ne_core=DNE_CORE_FINAL[ww]
cdf_data.d_te_core=DTE_CORE_FINAL[ww]
cdf_data.qf_te_core=1.
cdf_data.r_dist=R_EPHEM_FINAL[ww]
cdf_data.latitude=LAT_EPHEM_FINAL[ww]
cdf_data.local_time=LT_EPHEM_FINAL[ww]
cdf_data.l_shell=LSHELL_EPHEM_FINAL[ww]

;cdf_data.b_mag=BMAG_FINAL
print,"File    = "+files[j]
print,"N_data  ="+string(cnt)
print,"T_start = "+cdf_data.SCET[0]
print,"T_stop  = "+cdf_data.SCET[cnt-1]

STR_TIME_START = cdf_data.SCET[0]
STR_TIME_STOP  = cdf_data.SCET[cnt-1]

STR_AJDHM_BEG = strjoin([strsplit(strmid(STR_TIME_START,0,10),'-',/extract),strmid(STR_TIME_START,11,2),strmid(STR_TIME_START,14,2)])
STR_AJDHM_END = strjoin([strsplit(strmid(STR_TIME_STOP,0,10),'-',/extract),strmid(STR_TIME_STOP,11,2),strmid(STR_TIME_STOP,14,2)])

cdf_file_name = cdf_datapath+'data/co_rpws_hfr_qtn_'+STR_AJDHM_BEG+'_'+STR_AJDHM_END+'_v'+sav_version+'.cdf'
pdf_file_name = cdf_datapath+'plots/co_rpws_hfr_qtn_'+STR_AJDHM_BEG+'_'+STR_AJDHM_END+'_v'+sav_version+'.pdf'
png_file_name = cdf_datapath+'plots/co_rpws_hfr_qtn_'+STR_AJDHM_BEG+'_'+STR_AJDHM_END+'_v'+sav_version+'.png'
xml_cdf_file_name = cdf_datapath+'xml/co_rpws_hfr_qtn_'+STR_AJDHM_BEG+'_'+STR_AJDHM_END+'_v'+sav_version+'-data.xml'
xml_pdf_file_name = cdf_datapath+'xml/co_rpws_hfr_qtn_'+STR_AJDHM_BEG+'_'+STR_AJDHM_END+'_v'+sav_version+'-browse.xml'
xml_png_file_name = cdf_datapath+'xml/co_rpws_hfr_qtn_'+STR_AJDHM_BEG+'_'+STR_AJDHM_END+'_v'+sav_version+'-thumbnail.xml'

;spawn,'convert -resize 50%x50% -background white -flatten '+pdf_file_name+' '+png_file_name

; start of prime
cdf_epoch,epoch_equinox,2008,06,30,23,59,59,999,/compute
cdf_epoch,epoch_solstice,2010,10,11,23,59,59,999,/compute
cdf_epoch,epoch_proximal,2016,10,31,23,59,59,999,/compute
; end of mission: 2017 September 15.

STR_mission = "Tour>Prime Mission"

if cdf_data.epoch[cnt-1] gt epoch_equinox then STR_mission = "Extended Mission>Equinox Mission"
if cdf_data.epoch[cnt-1] gt epoch_solstice then STR_mission = "Extended-Extended Mission>Solstice Mission"
if cdf_data.epoch[cnt-1] gt epoch_proximal then STR_mission = "Extended-Extended Mission>Proximal Orbits"

  ; CASSINI ORBIT NUMBER
rev_id = strmid(files[j],25,3)

  ; PREPARING CDF GLOBAL ATTRIBUTES 
CDF_GATTR = {PDS_ORBIT_NUMBER:"", PDS_MISSION_PHASE:"", PDS_START_TIME:"", PDS_STOP_TIME:"" ,$
             PDS_collection_id: '', PDS_LID:"", PDS_LID_browse: "", PDS_LID_thumbnail: "",$
             VESPA_TIME_MIN:0.0d0, VESPA_TIME_MAX:0.0d0, $
             VESPA_TIME_SAMPLING_MIN:0.0, VESPA_TIME_SAMPLING_MAX:0.0d0, $
             VESPA_C1_MIN:0.0, VESPA_C1_MAX:0.0, $
             VESPA_C2_MIN:0.0, VESPA_C2_MAX:0.0, $
             VESPA_C3_MIN:0.0, VESPA_C3_MAX:0.0, $
             VESPA_C1_RESOL_MIN:0.0, VESPA_C1_RESOL_MAX:0.0, $
             VESPA_C2_RESOL_MIN:0.0, VESPA_C2_RESOL_MAX:0.0, $
             VESPA_C3_RESOL_MIN:0.0, VESPA_C3_RESOL_MAX:0.0, $
             DATA_VERSION:"", SKELETON_VERSION:"", SOFTWARE_VERSION:"", $
             file_orig_name:'',$
             file_browse_name:'',    file_browse_size:0l,$
             file_thumbnail_name:'', file_thumbnail_size:0l}

; SETTING PDS GLOBAL ATTRIBUTES
CDF_GATTR.PDS_ORBIT_NUMBER = strmid(files[j],25,3)
CDF_GATTR.PDS_MISSION_PHASE = STR_Mission
CDF_GATTR.PDS_START_TIME = STR_TIME_START
CDF_GATTR.PDS_STOP_TIME = STR_TIME_STOP
CDF_GATTR.PDS_collection_id = "urn:nasa:pds:co-rpws-saturn:data-hfr-qtn"
CDF_GATTR.PDS_LID           = "urn:nasa:pds:co-rpws-saturn:data-hfr-qtn:cdf-"+STR_AJDHM_BEG+'-'+STR_AJDHM_END
CDF_GATTR.PDS_LID_browse    = "urn:nasa:pds:co-rpws-saturn:browse-hfr-qtn:pdf-"+STR_AJDHM_BEG+'-'+STR_AJDHM_END
CDF_GATTR.PDS_LID_thumbnail = "urn:nasa:pds:co-rpws-saturn:thumbnail-hfr-qtn:png-"+STR_AJDHM_BEG+'-'+STR_AJDHM_END
;CDF_GATTR.PDS_observation_target = 'Saturn'
;CDF_GATTR.PDS_observation_type = 'Plasma'

; SETTING VESPA GLOBAL ATTRIBUTES
CDF_GATTR.VESPA_TIME_MIN = cdf_data.jd_time[0]
CDF_GATTR.VESPA_TIME_MAX = cdf_data.jd_time[cnt-1]
CDF_GATTR.VESPA_TIME_SAMPLING_MIN= min(cdf_data.jd_time[1:cnt-1]-cdf_data.jd_time[0:cnt-2])*86400.
CDF_GATTR.VESPA_TIME_SAMPLING_MAX= max(cdf_data.jd_time[1:cnt-1]-cdf_data.jd_time[0:cnt-2])*86400.
CDF_GATTR.VESPA_C1_MIN= min(cdf_data.latitude)
CDF_GATTR.VESPA_C1_MAX= max(cdf_data.latitude)
CDF_GATTR.VESPA_C2_MIN= min(cdf_data.local_time)
CDF_GATTR.VESPA_C2_MAX= max(cdf_data.local_time)
CDF_GATTR.VESPA_C3_MIN= min(cdf_data.r_dist)
CDF_GATTR.VESPA_C3_MAX= max(cdf_data.r_dist)
CDF_GATTR.VESPA_C1_RESOL_MIN= min(abs(cdf_data.latitude[1:cnt-1]-cdf_data.latitude[0:cnt-2]))
CDF_GATTR.VESPA_C1_RESOL_MAX= max(abs(cdf_data.latitude[1:cnt-1]-cdf_data.latitude[0:cnt-2]))
CDF_GATTR.VESPA_C2_RESOL_MIN= min(abs(cdf_data.local_time[1:cnt-1]-cdf_data.local_time[0:cnt-2]))
CDF_GATTR.VESPA_C2_RESOL_MAX= max(abs(cdf_data.local_time[1:cnt-1]-cdf_data.local_time[0:cnt-2]))
CDF_GATTR.VESPA_C3_RESOL_MIN= min(abs(cdf_data.r_dist[1:cnt-1]-cdf_data.r_dist[0:cnt-2]))
CDF_GATTR.VESPA_C3_RESOL_MAX= max(abs(cdf_data.r_dist[1:cnt-1]-cdf_data.r_dist[0:cnt-2]))

CDF_GATTR.DATA_VERSION = strmid(sav_version,0,1)+'.'+strmid(sav_version,1)
CDF_GATTR.SKELETON_VERSION = strmid(cdf_version,0,1)+'.'+strmid(cdf_version,1)
CDF_GATTR.SOFTWARE_VERSION = strmid(sft_version,0,1)+'.'+strmid(sft_version,1)

CDF_GATTR.file_orig_name = file_basename(files[j])

CDF_GATTR.file_browse_name = file_basename(pdf_file_name)
finfo = file_info(pdf_file_name)
CDF_GATTR.file_browse_size = finfo.size

CDF_GATTR.file_thumbnail_name = file_basename(png_file_name)
finfo = file_info(png_file_name)
CDF_GATTR.file_thumbnail_size = finfo.size

  ; PREPARING CDF VARIABLE ATTRIBUTES 
CDF_VATTR = {EPOCH:{VALIDMIN:0.D0,VALIDMAX:0.D0,SCALEMIN:0.D0,SCALEMAX:0.D0}, $
             SCET:{VALIDMIN:"",VALIDMAX:"",SCALEMIN:"",SCALEMAX:""}, $
             JD_TIME:{VALIDMIN:0.d0,VALIDMAX:0.d0,SCALEMIN:0.d0,SCALEMAX:0.d0}}

  ; SETTING CDF EPOCH VARIABLE ATTRIBUTES 
CDF_VATTR.EPOCH.VALIDMIN = cdf_data.epoch[0]
CDF_VATTR.EPOCH.VALIDMAX = cdf_data.epoch[cnt-1]
CDF_VATTR.EPOCH.SCALEMIN = floor(cdf_data.epoch[0] / 21.6D6)*21.6D6
CDF_VATTR.EPOCH.SCALEMAX = ceil(cdf_data.epoch[cnt-1] / 21.6D6)*21.6D6

  ; SETTING CDF SCET VARIABLE ATTRIBUTES 
CDF_VATTR.SCET.VALIDMIN = cdf_encode_epoch(cdf_data.epoch[0],epoch=3)
CDF_VATTR.SCET.VALIDMAX = cdf_encode_epoch(cdf_data.epoch[cnt-1],epoch=3)
CDF_VATTR.SCET.SCALEMIN = cdf_encode_epoch(floor(cdf_data.epoch[0] / 21.6D6)*21.6D6,epoch=3)
CDF_VATTR.SCET.SCALEMAX = cdf_encode_epoch(ceil(cdf_data.epoch[cnt-1] / 21.6D6)*21.6D6,epoch=3)

  ; SETTING CDF JD_TIME VARIABLE ATTRIBUTES 
CDF_VATTR.JD_TIME.VALIDMIN = cdf_data.jd_time[0]
CDF_VATTR.JD_TIME.VALIDMAX = cdf_data.jd_time[cnt-1]
CDF_VATTR.JD_TIME.SCALEMIN = floor(cdf_data.jd_time[0] * 6.d0)/6.d0
CDF_VATTR.JD_TIME.SCALEMAX = ceil(cdf_data.jd_time[cnt-1] *6.d0)/6.d0


  ; DATA PERIOD OUTPUT 
printf,lun1,"    "+rev_id + string(format='(" ",I5,"  ",A,"  ",A)',cnt,strmid(cdf_data.SCET[0],0,16),strmid(cdf_data.SCET[cnt-1],0,16)) 

print,'deleting previous CDF file'
spawn,'rm -rf '+cdf_file_name

make_cdf,master_cdf,cdf_file_name,cdf_data,GATTR=CDF_GATTR,VATTR=CDF_VATTR;,/VERBOSE

spawn,'cdfconvert -d '+cdf_file_name+' '+cdf_file_name

print,'Producing PDS4 XML label files:'
spawn,'pwd',idl_work_dir
cd,cdf_datapath
spawn,'/Users/baptiste/Development/igpp-docgen/bin/docgen cdf:data/'+file_basename(cdf_file_name)+' co_rpws_hfr_qtn_v11_cdf.vm > xml/'+file_basename(xml_cdf_file_name)
spawn,'/Users/baptiste/Development/igpp-docgen/bin/docgen cdf:data/'+file_basename(cdf_file_name)+' co_rpws_hfr_qtn_v11_pdf.vm > xml/'+file_basename(xml_pdf_file_name)
spawn,'/Users/baptiste/Development/igpp-docgen/bin/docgen cdf:data/'+file_basename(cdf_file_name)+' co_rpws_hfr_qtn_v11_png.vm > xml/'+file_basename(xml_png_file_name)
cd,idl_work_dir

print,'checking PDS4 compliance:'
spawn,'/Users/baptiste/Development/pds-cdf/bin/cdfcheck -v '+cdf_file_name
spawn,'/Users/baptiste/Development/pds-cdf/bin/cdfcheck '+cdf_file_name,txt_result
printf,lun2,rev_id+': '+txt_result

;print,'Building quicklook:'

endfor

close,lun1
close,lun2
free_lun,lun1
free_lun,lun2

end
