; IDL Version 7.0, Mac OS X (darwin i386 m32)
; Journal File for baptiste@macbookbc.obspm.fr
; Working directory: /Users/baptiste/Projets/CDPP/Archivage/Cassini:RPWS/HFR/SND
; Date: Thu Jun 12 12:04:25 2014
;
; RUN @compile_IDLmakecdf
;
; NB: compile_IDLmakecdf.pro script is part of the CDF CDAWlib distribution 
; available here: http://spdf.gsfc.nasa.gov/CDAWlib.html

; DECLARING VERSIONS
sft_version = '02'
cdf_version = '02'
dat_version = '02'

; DECLARING PATHS
cdf_datapath = '../data/cdf/V'+sft_version+'/'
dat_datapath = '../data/dat/V'+dat_version+'/diag/'
master_cdf = cdf_datapath+'master/co_rpws_hfr_snd_l3_000000000000_000000000000_v'+cdf_version+'.cdf'
skelet_cdf = 'skt/co_rpws_hfr_snd_l3_000000000000_000000000000_v'+cdf_version+'.skt'

; CLEANING AND REBUILDING MASTER CDF
spawn,'rm -f '+master_cdf
spawn,'skeletoncdf -cdf '+master_cdf+' '+skelet_cdf

; OPENING 2 FILES FOR HOUSEKEEPING OUTPUT
openw,lun1,cdf_datapath+'misc/interval_listing.txt',/get_lun
printf,lun1,"    REV NDATA  TIME START        TIME STOP            "
printf,lun1,"    --- -----  ----------------  ----------------     "
printf,lun1,"                                                      "

openw,lun2,cdf_datapath+'misc/cdf_pds_check.txt',/get_lun

; BUILDING LIST OF DATA FILES
files = file_search(dat_datapath+"t???????MEANv??.txt")
nfiles = n_elements(files)
message,/info,'Found '+strtrim(string(nfiles),2)+' input files.'

; LOADING ORBIT DATA
restore,'/Users/baptiste/Projets/Cassini/Orbits/cassini_orbits.sav'

; =============================================================================
; LOOPING ON DATA FILES
; =============================================================================

for j=0l,N_ELEMENTS(files)-1 do begin

  ; LOADING DATA
  read_rpws_sounder_l3_data,files[j],data
  ndata = n_elements(data)
  
  ; BUILDING TIME VARIABLES
  time_epoch = dblarr(ndata)
  time_jd = data.jd_time
  time_iso = strarr(ndata)
  for i=0l,ndata-1 do begin
    caldat, time_jd[i], MO, DD, YY, HH, MI, SS
    cdf_epoch,epoch_tmp,YY, MO, DD, HH, MI, SS,/compute 
    time_epoch[i] = epoch_tmp
    time_iso[i] = cdf_encode_epoch(epoch_tmp,epoch=3)
  endfor

  ; CONSTRUCTING CDF_DATA STRUCTURE
  cdf_data = {epoch:dblarr(ndata),jd_time:dblarr(ndata),scet:strarr(ndata), $
            frequency:fltarr(ndata),amplitude:dblarr(ndata), $
			quality_factor_value:bytarr(ndata), $
			index_spectrum_value:bytarr(ndata)}
			
  ; FILLING CDF_DATA STRUCTURE
  cdf_data.epoch=time_epoch
  cdf_data.jd_time=time_jd
  cdf_data.scet=time_iso
  cdf_data.frequency=data.frequency
  cdf_data.amplitude=data.amplitude
  cdf_data.QUALITY_FACTOR_VALUE=data.quality_factor_value
  cdf_data.index_spectrum_value=data.index_spectrum_value

  ; SOME STATUS OUTPUT 
  print,"File    = "+files[j]
  print,"N_data  ="+string(ndata)
  print,"T_start = "+cdf_data.SCET[0]
  print,"T_stop  = "+cdf_data.SCET[ndata-1]

  ; PREPARING CDF FILE 
  STR_TIME_START = cdf_data.SCET[0]
  STR_TIME_STOP  = cdf_data.SCET[ndata-1]

  STR_AJDHM_BEG = strjoin([strsplit(strmid(STR_TIME_START,0,10),'-',/extract),strmid(STR_TIME_START,11,2),strmid(STR_TIME_START,14,2)])
  STR_AJDHM_END = strjoin([strsplit(strmid(STR_TIME_STOP,0,10),'-',/extract),strmid(STR_TIME_STOP,11,2),strmid(STR_TIME_STOP,14,2)])

  ; BUILDING CDF FILENAME 
  cdf_file_name = cdf_datapath+'data/co_rpws_hfr_snd_l3_'+STR_AJDHM_BEG+'_'+STR_AJDHM_END+'_v'+dat_version+'.cdf'
  pdf_file_name = cdf_datapath+'plots/co_rpws_hfr_snd_l3_'+STR_AJDHM_BEG+'_'+STR_AJDHM_END+'_v'+dat_version+'.pdf'
  png_file_name = cdf_datapath+'plots/co_rpws_hfr_snd_l3_'+STR_AJDHM_BEG+'_'+STR_AJDHM_END+'_v'+dat_version+'.png'
  xml_cdf_file_name = cdf_datapath+'xml/co_rpws_hfr_snd_l3_'+STR_AJDHM_BEG+'_'+STR_AJDHM_END+'_v'+dat_version+'-data.xml'
  xml_pdf_file_name = cdf_datapath+'xml/co_rpws_hfr_snd_l3_'+STR_AJDHM_BEG+'_'+STR_AJDHM_END+'_v'+dat_version+'-browse.xml'
  xml_png_file_name = cdf_datapath+'xml/co_rpws_hfr_snd_l3_'+STR_AJDHM_BEG+'_'+STR_AJDHM_END+'_v'+dat_version+'-thumbnail.xml'

 ;  spawn,'/Applications/VO-tools/topcat-4.2-2/bin/stilts plot2time in='+cdf_file_name+' out='+pdf_file_name+$
 ;        ' layer1=mark t1=Epoch y1=FREQUENCY leglabel1=''Plasma Frequency derived for Cassini RPWS HFR Sounder mode Data'' '+$
 ;   	'ylabel=''Plasma Frequency (kHz)'' tlabel=''SCET'' tcrowd=10 xpix=1000 ypix=300 ymin=3 ymax=300 ylog=true '+$
 ;  	'shape1=filled_square size1=1 legend=true legpos=0.5,0.95'
  
 ; spawn,'convert -resize 50%x50% -background white -flatten '+pdf_file_name+' '+png_file_name
  
  ; CASSINI MISSION PHASES
  ; start of prime
  cdf_epoch,epoch_equinox,2008,06,30,23,59,59,999,/compute
  cdf_epoch,epoch_solstice,2010,10,11,23,59,59,999,/compute
  cdf_epoch,epoch_proximal,2016,10,31,23,59,59,999,/compute
  ; end of mission: 2017 September 15.

  STR_mission = "Tour>Prime Mission"

  if cdf_data.epoch[ndata-1] gt epoch_equinox then STR_mission = "Extended Mission>Equinox Mission"
  if cdf_data.epoch[ndata-1] gt epoch_solstice then STR_mission = "Extended-Extended Mission>Solstice Mission"
  if cdf_data.epoch[ndata-1] gt epoch_proximal then STR_mission = "Extended-Extended Mission>Proximal Orbits"

  ; CASSINI ORBIT NUMBER
  ww = where(orbit_start_time_jd gt time_jd[0])
  if ww[0] eq 0 then STR_orbit_number = 'CRUISE' else STR_orbit_number = orbit_name[ww[0]-1]
  if strlen(STR_orbit_number) eq 1 then STR_orbit_number =  '00'+STR_orbit_number
  if strlen(STR_orbit_number) eq 2 then STR_orbit_number =  '0'+STR_orbit_number

  ; PREPARING CDF GLOBAL ATTRIBUTES 
  CDF_GATTR = {PDS_ORBIT_NUMBER:"", PDS_MISSION_PHASE:"", PDS_START_TIME:"", PDS_STOP_TIME:"" ,$
               PDS_collection_id: '', PDS_LID:"", PDS_LID_browse: "", PDS_LID_thumbnail: "",$
               VESPA_TIME_MIN:0.0d0, VESPA_TIME_MAX:0.0d0, $
               VESPA_TIME_SAMPLING_MIN:0.0, VESPA_TIME_SAMPLING_MAX:0.0d0, $
;               spectral_range_min:0.0, 	 spectral_range_max:0.0, $
;               spectral_sampling_step_min:0.0, 	 spectral_sampling_step_max:0.0, $
;               spectral_resolution_min:0.0, 	 spectral_resolution_max:0.0, $
;             C1_MIN:0.0, C1_MAX:0.0, C2_MIN:0.0, C2_MAX:0.0, C3_MIN:0.0, C3_MAX:0.0, $
;             C1_RESOL_MIN:0.0, C1_RESOL_MAX:0.0, C2_RESOL_MIN:0.0, C2_RESOL_MAX:0.0, $
;             C3_RESOL_MIN:0.0, C3_RESOL_MAX:0.0, $
               DATA_VERSION:"", SKELETON_VERSION:"", SOFTWARE_VERSION:"", $
               file_orig_name:'',$
               file_browse_name:'',    file_browse_size:0l,$
               file_thumbnail_name:'', file_thumbnail_size:0l}

  ; SETTING PDS GLOBAL ATTRIBUTES
  CDF_GATTR.PDS_ORBIT_NUMBER = STR_orbit_number
  CDF_GATTR.PDS_MISSION_PHASE = STR_Mission
  CDF_GATTR.PDS_START_TIME = STR_TIME_START
  CDF_GATTR.PDS_STOP_TIME = STR_TIME_STOP
  CDF_GATTR.PDS_collection_id = "urn:nasa:pds:co-rpws-saturn:data-hfr-snd-l3"
  CDF_GATTR.PDS_LID           = "urn:nasa:pds:co-rpws-saturn:data-hfr-snd-l3:cdf-"+STR_AJDHM_BEG+'-'+STR_AJDHM_END
  CDF_GATTR.PDS_LID_browse    = "urn:nasa:pds:co-rpws-saturn:browse-hfr-snd-l3:pdf-"+STR_AJDHM_BEG+'-'+STR_AJDHM_END
  CDF_GATTR.PDS_LID_thumbnail = "urn:nasa:pds:co-rpws-saturn:thumbnail-hfr-snd-l3:png-"+STR_AJDHM_BEG+'-'+STR_AJDHM_END

  ; SETTING VESPA GLOBAL ATTRIBUTES
  CDF_GATTR.VESPA_TIME_MIN = cdf_data.jd_time[0]
  CDF_GATTR.VESPA_TIME_MAX = cdf_data.jd_time[ndata-1]
  CDF_GATTR.VESPA_TIME_SAMPLING_MIN= min(cdf_data.jd_time[1:ndata-1]-cdf_data.jd_time[0:ndata-2])*86400.
  CDF_GATTR.VESPA_TIME_SAMPLING_MAX= max(cdf_data.jd_time[1:ndata-1]-cdf_data.jd_time[0:ndata-2])*86400.

  CDF_GATTR.DATA_VERSION = strmid(dat_version,0,1)+'.'+strmid(dat_version,1)
  CDF_GATTR.SKELETON_VERSION = strmid(cdf_version,0,1)+'.'+strmid(cdf_version,1)
  CDF_GATTR.SOFTWARE_VERSION = strmid(sft_version,0,1)+'.'+strmid(sft_version,1)

  CDF_GATTR.file_orig_name = file_basename(files[j])

  CDF_GATTR.file_browse_name = file_basename(pdf_file_name)
  finfo = file_info(pdf_file_name)
  CDF_GATTR.file_browse_size = finfo.size
  
  CDF_GATTR.file_thumbnail_name = file_basename(png_file_name)
  finfo = file_info(png_file_name)
  CDF_GATTR.file_thumbnail_size = finfo.size

  ; PREPARING CDF VARIABLE ATTRIBUTES 
  CDF_VATTR = {EPOCH:{VALIDMIN:0.D0,VALIDMAX:0.D0,SCALEMIN:0.D0,SCALEMAX:0.D0}, $
               SCET:{VALIDMIN:"",VALIDMAX:"",SCALEMIN:"",SCALEMAX:""}, $
               JD_TIME:{VALIDMIN:0.d0,VALIDMAX:0.d0,SCALEMIN:0.d0,SCALEMAX:0.d0}}

  ; SETTING CDF EPOCH VARIABLE ATTRIBUTES 
  CDF_VATTR.EPOCH.VALIDMIN = cdf_data.epoch[0]
  CDF_VATTR.EPOCH.VALIDMAX = cdf_data.epoch[ndata-1]
  CDF_VATTR.EPOCH.SCALEMIN = floor(cdf_data.epoch[0] / 21.6D6)*21.6D6
  CDF_VATTR.EPOCH.SCALEMAX = ceil(cdf_data.epoch[ndata-1] / 21.6D6)*21.6D6

  ; SETTING CDF SCET VARIABLE ATTRIBUTES 
  CDF_VATTR.SCET.VALIDMIN = cdf_encode_epoch(cdf_data.epoch[0],epoch=3)
  CDF_VATTR.SCET.VALIDMAX = cdf_encode_epoch(cdf_data.epoch[ndata-1],epoch=3)
  CDF_VATTR.SCET.SCALEMIN = cdf_encode_epoch(floor(cdf_data.epoch[0] / 21.6D6)*21.6D6,epoch=3)
  CDF_VATTR.SCET.SCALEMAX = cdf_encode_epoch(ceil(cdf_data.epoch[ndata-1] / 21.6D6)*21.6D6,epoch=3)

  ; SETTING CDF JD_TIME VARIABLE ATTRIBUTES 
  CDF_VATTR.JD_TIME.VALIDMIN = cdf_data.jd_time[0]
  CDF_VATTR.JD_TIME.VALIDMAX = cdf_data.jd_time[ndata-1]
  CDF_VATTR.JD_TIME.SCALEMIN = floor(cdf_data.jd_time[0] * 6.d0)/6.d0
  CDF_VATTR.JD_TIME.SCALEMAX = ceil(cdf_data.jd_time[ndata-1] *6.d0)/6.d0


  ; DATA PERIOD OUTPUT 
  printf,lun1,"    "+STR_orbit_number + string(format='("   ",I5,"  ",A,"  ",A)',ndata,strmid(cdf_data.SCET[0],0,16),strmid(cdf_data.SCET[ndata-1],0,16)) 

  ; CLEANING PREVIOUS CDF FILE 
  print,'deleting previous CDF file'
  spawn,'rm -rf '+cdf_file_name

  ; BUILDING AND FILLING CDF FILE 
  make_cdf,master_cdf,cdf_file_name,cdf_data,GATTR=CDF_GATTR,VATTR=CDF_VATTR;,/VERBOSE

  ; CDF SCRIPT TRICK TO REMOVE UNUSED RECORDS 
  spawn,'cdfconvert -d '+cdf_file_name+' '+cdf_file_name

  print,'Producing PDS4 XML label files:'
  spawn,'pwd',idl_work_dir
  cd,cdf_datapath
  spawn,'/Users/baptiste/Development/igpp-docgen/bin/docgen cdf:data/'+file_basename(cdf_file_name)+' co_rpws_hfr_snd_l3_v02_cdf.vm > xml/'+file_basename(xml_cdf_file_name)
  spawn,'/Users/baptiste/Development/igpp-docgen/bin/docgen cdf:data/'+file_basename(cdf_file_name)+' co_rpws_hfr_snd_l3_v02_pdf.vm > xml/'+file_basename(xml_pdf_file_name)
  spawn,'/Users/baptiste/Development/igpp-docgen/bin/docgen cdf:data/'+file_basename(cdf_file_name)+' co_rpws_hfr_snd_l3_v02_png.vm > xml/'+file_basename(xml_png_file_name)
  cd,idl_work_dir

  ; CDF SCRIPT TO CHECK PDS4 COMPATIBILITY
  print,'checking PDS4 compliance:'
  spawn,'/Users/baptiste/Development/pds-cdf/bin/cdfcheck -v '+cdf_file_name
  spawn,'/Users/baptiste/Development/pds-cdf/bin/cdfcheck '+cdf_file_name,txt_result
  printf,lun2,+'co_rpws_hfr_snd_l3_'+STR_AJDHM_BEG+'_'+STR_AJDHM_END+'_v'+sft_version+'.cdf: rev='+STR_orbit_number+' / '+txt_result

endfor
; =============================================================================
; END MAIN LOOP
; =============================================================================


; CLOSING HOUSEKEEPING FILES
close,lun1
close,lun2
free_lun,lun1
free_lun,lun2

end
